import { Text, Pressable } from "react-native";
import React from "react";
import { billingInfoStyle } from "./BillingInformationStyle";
import { useNavigation } from "@react-navigation/native";
import useLangTranslation from "../../../hooks/useLangTranslation";
import useGuestUser from "../../../hooks/useGuestUser";

const AddNewAddressBtn = () => {
    const isGuest = useGuestUser();
    const navigation = useNavigation();
    const { trans } = useLangTranslation();

    const handleAddNewAddress = () => {
        if (isGuest) {
            navigation.navigate('guest add new address', {
                isUpdate: false,
            });
        }
        else {
            navigation.navigate("add new address", {
                isUpdate: false,
            })
        }
    };

    return (
        <Pressable
            style={[
                billingInfoStyle.otherAddressCont,
                billingInfoStyle.addAddressBtn,
            ]}
            onPress={handleAddNewAddress}
        >
            <Text style={[billingInfoStyle.text, billingInfoStyle.mt]}>
                + {trans("Add New Address")}
            </Text>
        </Pressable>
    );
};

export default AddNewAddressBtn;
